/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.config;

import filenet.vw.apps.config.VWConfigCore;
import filenet.vw.apps.config.images.VWImageLoader;
import filenet.vw.apps.config.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;

public class VWConfigApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener {
    private VWConfigCore m_configCore = null;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            if (!sessionInfo.verifyLogon(VWResource.s_pwConfigurationGroup)) {
                System.exit(1);
            }
            VWConfigApplication pApp = new VWConfigApplication();
            pApp.init(sessionInfo);
            VWHelp.init(pApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            System.exit(1);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            VWSplashWindow splashWindow = new VWSplashWindow(this);
            this.setTitle(VWIDMBaseFactory.instance().getVWString(4).toString());
            ImageIcon icon = VWImageLoader.createImageIcon("Config_3D_32.gif");
            if (icon != null && icon.getImage() != null) {
                this.setIconImage(icon.getImage());
            }
            if (!this.updatePosition("config_location", "config_size")) {
                Dimension dim = VWStringUtils.stringToDimension(VWResource.s_mainWindowDim);
                if (dim == null) {
                    dim = new Dimension(800, 600);
                }
                this.updatePosition(dim.width, dim.height);
            }
            this.setVisible(true);
            if (splashWindow != null) {
                splashWindow.start(this, 1000);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            this.m_configCore = new VWConfigCore();
            this.m_configCore.init(this.m_sessionInfo);
            try {
                if (!this.m_sessionInfo.isAllowedToRunConfigurationApp()) {
                    VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_insufficentRights, 1);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
                    return;
                }
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
                return;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean destroy() {
        try {
            if (this.m_configCore != null) {
                this.m_configCore.destroy();
            }
            return super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }
}

